<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('observations', function (Blueprint $table) {
            $table->increments('observation_id');
            $table->unsignedInteger('commande_id');
            $table->foreign('commande_id')->references('commande_id')->on('commandes');
            $table->dateTime('date_observation');
            $table->integer('user_id');
            $table->integer('centre_id');
            $table->integer('dps_id');
            $table->string('libelle');
            $table->string('type');
            $table->date('read_at')->nullable(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('observations');
    }
};
